// Computes the high-order half of the 64-bit product.
// Max line length is 57, to fit in hacker.book.
// Derived from Knuth's Algorithm M, altered for signed multiplication.
// Subscript 0 denotes the least significant half (little endian).
#include <stdio.h>
#include <stdlib.h>     // To define "exit", req'd by XLC.

int mulhs(int u, int v) {
   unsigned u0, v0, w0;
   int u1, v1, w1, w2, t;

   u0 = u & 0xFFFF;  u1 = u >> 16;
   v0 = v & 0xFFFF;  v1 = v >> 16;
   w0 = u0*v0;
   t  = u1*v0 + (w0 >> 16);
   w1 = t & 0xFFFF;
   w2 = t >> 16;
   w1 = u0*v1 + w1;
   return u1*v1 + w2 + (w1 >> 16);
}

int errors;
void error(int u, int v, int r) {
   errors = errors + 1;
   printf("Error for u = %08x, v = %08x, got %08x (%d dec)\n", u, v, r, r);
}

int main() {
   int i, r, n;
   static int test[] = {0,0,0, 0,1,0, 0,0x7fffffff,0,
      0,0xffffffff,0, 1,0x7fffffff,0, 1,-1,-1,
      0xffff,0xffff,0, 0x10000,0xffff,0, 0x100000,0xffff,0xf,
      0xfffff,0xeeeee,0xee, 0x7fffffff,0x7eeeeeee,0x3f777776,
      0x7fffffff,0x7fffffff,0x3fffffff, -1,-1,0, -100,-200,0,
      -32768,-32768,0, -65536,-65536,1, -65536,65536,0xffffffff,
      -100000,100000,0xfffffffd, -100000,-150000,3,
      0x12345678,0x23456789,0x0282174A,
      0x12345678,0x87654321,0xF76C768D,
      0x12345678,0x87878787,0xF76EE65E,
      0x9ABCDEF0,0xABCDEF01,0x214DD4AE,
      0x80000000,0x7fffffff,0xc0000000,
      0x80000000,0x80000000,0x40000000,
      0xc0000000,0xc0000000, 0x10000000};

   n = sizeof(test)/4;

   printf("mulhs:\n");
   for (i = 0; i < n; i += 3) {
      r = mulhs(test[i], test[i+1]);
      if (r != test[i+2]) error(test[i], test[i+1], r);
      r = mulhs(test[i+1], test[i]);
      if (r != test[i+2]) error(test[i+1], test[i], r);}

   if (errors == 0)
      printf("Passed all %d cases.\n", n/3);
}
